﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultNetworkPlugin.Controls.Strategy
{
    public interface IQueryIpMatchingStrategy
    {
        void Write(int num);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class QueryIpMatchingDefaultStrategy : ICorrespondenceOS, IQueryIpMatchingStrategy
    {
        public QueryIpMatchingDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,

#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "QueryIpMatching";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion


        public void Write(int num)
        {
            RegistryKey registryKey =
                Registry.LocalMachine.CreateSubKey(
                    @"System\CurrentControlSet\Services\Dnscache\Parameters");
            RegistryKey registryKey2 =
                Registry.LocalMachine.CreateSubKey(
                    @"SYSTEM\CurrentControlSet\Services\Tcpip\Parameters");

            registryKey.SetValue(RegName, num, RegistryValueKind.DWord);
            registryKey2.SetValue(RegName, num, RegistryValueKind.DWord);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.LocalMachine.OpenSubKey(
                    @"System\CurrentControlSet\Services\Dnscache\Parameters");
            RegistryKey registryKey2=
                Registry.LocalMachine.OpenSubKey(
                    @"SYSTEM\CurrentControlSet\Services\Tcpip\Parameters");

            return new WFRegistry(@"HKEY_LOCAL_MACHINE\System\CurrentControlSet\Services\Dnscache\Parameters", RegName,
                                  (int)registryKey.GetValue(RegName, 0)&(int)registryKey2.GetValue(RegName,0), RegistryValueKind.DWord, RegOperation.ValueWrite);
        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

    }

    public class QueryIpMatchingController
    {
        public QueryIpMatchingController(QueryIpMatching queryIpMatching,
                                                         IQueryIpMatchingStrategy strategy)
        {
            QueryIpMatching = queryIpMatching;
            Strategy = strategy;
        }

        public QueryIpMatching QueryIpMatching { get; set; }
        public IQueryIpMatchingStrategy Strategy { get; set; }

        public void Read()
        {
            QueryIpMatching.SetQueryIpMatchingValue(Convert.ToInt32(Strategy.Read().Value));
        }

        public void Write()
        {
            Strategy.Write(QueryIpMatching.GetQueryIpMatchingValue());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
